# Succinct network channle and spatial pruning via discrete variable qcqp

Implementation with Pytorch.

## Requirements
- Python 3.6.10
- PyTorch 1.3.1
- TorchVision 0.4.2
- matplotlib 3.1.1
- cplex 12.10.0 => You need to install academic version (restricted usage for community version).

## Pretrained Network
- Download 'pretrained_networks.zip' from google drive.
```bash
wget --no-check-certificate -r 'https://docs.google.com/uc?export=download&id=1ZRL84HmoRG28c7IOSDu5gKNwxGcLIsPU' -O pretrained_networks.zip
```
- Unzip to generate './pretrained_networks/'.
```bash
unzip pretrained_networks.zip
```

## Training ResNet on Cifar-10
Run Pruning Training ResNet (depth 56,32,20) on Cifar10:

```bash
python exp/cifar_exp/main.py --mode (mode) --timelimit (timelimit) --baseseed (baseseed) --target_c (target) --arch (arch)
e.g.) python exp/cifar_exp/main.py --mode flops_2D --timelimit 5000 --baseseed 4 --target_c 0.46 --arch resnet20
e.g.2.) python exp/cifar_exp/main.py --mode flops_4D --timelimit 500 --baseseed 4 --target_c 0.46 --ratio 0.5 --arch resnet20
```

* (mode) - 'flops_2D', 'flops_4D', 'mem_2D', 'mem_4D'
* (timelimit) - timelimit for CPLEX. for resnet20 - 5000, resnet32 - 20000, resnet56 - 80000.
* (baseseed) - (4,5,6) for resnet20, (1,2,3) for resnet32, resnet56
* (target_c) - ratio of target constraints and max constraints for conv layers. 0~1
* (gamma) - gamma for 4D. target_c ~ 1
* (arch) - 'resnet20', 'resnet32', 'resnet56'
